<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use App\Repository\TGroupsRepository;
use App\Repository\UserRepository;
use App\Entity\User;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Serializer\Encoder\JsonEncoder;

class AuthController extends AbstractController
{

    /** @var UserRepository $userRepository */
    private $userRepository;

    /** UserPasswordEncoderInterface $encoder */
    private $encoder;

    /**
     * AuthController Constructor
     *
     * @param UserRepository $userRepository*
     * @param tgroupsRepository $userRepository
     * @param UserPasswordEncoderInterface $encoder
    */
    public function __construct(UserRepository $userRepository, TGroupsRepository $tgroupsRepository, UserPasswordEncoderInterface $encoder)
    {
        $this->userRepository = $userRepository;
        $this->tgroupsRepository = $tgroupsRepository;
        $this->encoder = $encoder;
    }

    /**
    * api route redirects
    * @return Response
    */
    public function api()
    {
        return new Response(sprintf("Logged in as %s", $this->getUser()->getUsername()));
    }

    /**
     * Login new user
     * @param Request $request
     * @Route("/api/login_check", methods={"GET","POST"})
     * @return Response
     */
    public function login(Request $request)
    {
        return new Response(sprintf('User %s successfully created', $request->get('email')));
    }

     /**
     * Login new user
     * @param Request $request
     * @Route("/api/user", methods={"GET","POST"})
     * @return Response
     */
    public function user(Request $request)
    {
        return new Response(sprintf('User %s successfully created'));
    }

    /**
     * Register new user
     * @param Request $request
     * @Route("/register", methods={"GET","POST"})
     * @return Response
     */
    public function register(Request $request)
    {
        $myGroupId = 7;

        $groupId = $this->tgroupsRepository->findByGroupId($myGroupId);

        $user = new User();
        $user->setEmail($request->get('email'));

        $encoded = $this->encoder->encodePassword($user, $request->get('password'));
        $user->setPassword($encoded);

        $user->setGroupId($groupId);
        $entityManager = $this->getDoctrine()->getManager();
        $entityManager->persist($user);
        $entityManager->flush();

        return new Response(sprintf('User %s successfully created', $request->get('email')));
    }

     /**
     * Get users list
     * @param Request $request
     * @Route("/userbyemail", methods={"GET"})
     * @return Response
     */
    public function userbyemail(Request $request): Response
    {
        $myStaff = '';
        $arr = array();
        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.groupId, u.id, u.staffId FROM App\Entity\User u WHERE u.email = '" . $request->get('email') . "'");
        $myStaff = $queryG->getScalarResult();

        $arr[] = array(
            'groupId' => $myStaff[0]['groupId'],
                 'id' => $myStaff[0]['id'],
            'staffId' => $myStaff[0]['staffId']
        );

        return new JsonResponse($arr);

    }

    /**
     * @Route("/auth", name="auth")
     */
    public function index(): Response
    {
        return $this->render('auth/index.html.twig', [
            'controller_name' => 'AuthController',
        ]);
    }
}
