<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use App\Repository\TCompanyDetailsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_company_details:read"}, "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_company_details:write"}, "swagger_definition_name"="Write"}
 * )
 * @ORM\Entity(repositoryClass=TCompanyDetailsRepository::class)
 */
class TCompanyDetails
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_company_details:read", "t_company_details:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_company_details:read", "t_company_details:write" })
     */
    private $companyName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_company_details:read", "t_company_details:write" })
     */
    private $companyImg;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_company_details:read", "t_company_details:write" })
     */
    private $reportHeader;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_company_details:read", "t_company_details:write" })
     */
    private $reportFooter;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_company_details:read", "t_company_details:write" })
     */
    private $reportHeaderLower;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCompanyName(): ?string
    {
        return $this->companyName;
    }

    public function setCompanyName(?string $companyName): self
    {
        $this->companyName = $companyName;
        return $this;
    }

    public function getCompanyImg(): ?string
    {
        return $this->companyImg;
    }

    public function setCompanyImg(?string $companyImg): self
    {
        $this->companyImg = $companyImg;
        return $this;
    }

    public function getReportHeader(): ?string
    {
        return $this->reportHeader;
    }

    public function setReportHeader(?string $reportHeader): self
    {
        $this->reportHeader = $reportHeader;
        return $this;
    }

    public function getReportFooter(): ?string
    {
        return $this->reportFooter;
    }

    public function setReportFooter(?string $reportFooter): self
    {
        $this->reportFooter = $reportFooter;
        return $this;
    }

    public function getReportHeaderLower(): ?string
    {
        return $this->reportHeaderLower;
    }

    public function setReportHeaderLower(?string $reportHeaderLower): self
    {
        $this->reportHeaderLower = $reportHeaderLower;

        return $this;
    }
}
