<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TFinancialYearsRepository;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *      normalizationContext={"groups"={"t_financial_years:read"}, "swagger_definition_name"="Read"},
 *     denormalizationContext={"groups"={"t_financial_years:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "coaCode": "exact", "accountType": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TFinancialYearsRepository::class)
 */

class TFinancialYears
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_financial_years:read", "t_financial_years:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_financial_years:read", "t_financial_years:read"})
     */
    private $yearName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_financial_years:read", "t_financial_years:read"})
     */
    private $status;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getYearName(): ?string
    {
        return $this->yearName;
    }

    public function setYearName(?string $yearName): self
    {
        $this->yearName = $yearName;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }
}
