<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TPersonalizeRepository;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *      normalizationContext={"groups"={"t_personalizes:read"}, "swagger_definition_name"="Read"},
 *     denormalizationContext={"groups"={"t_personalizes:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TPersonalizeRepository::class)
 */

class TPersonalize
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_personalizes:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_personalizes:read", "t_personalizes:write"})
     */
    private $stockDue;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_personalizes:read", "t_personalizes:write"})
     */
    private $stockOut;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_personalizes:read", "t_personalizes:write"})
     */
    private $showSupplier;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_personalizes:read", "t_personalizes:write"})
     */
    private $supplierAmount;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_personalizes:read", "t_personalizes:write"})
     */
    private $showClient;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_personalizes:read", "t_personalizes:write"})
     */
    private $clientAmount;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_personalizes:read", "t_personalizes:write"})
     */
    private $useCashier;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_personalizes:read", "t_personalizes:write"})
     */
    private $institutionName;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStockDue(): ?string
    {
        return $this->stockDue;
    }

    public function setStockDue(?string $stockDue): self
    {
        $this->stockDue = $stockDue;

        return $this;
    }

    public function getStockOut(): ?string
    {
        return $this->stockOut;
    }

    public function setStockOut(?string $stockOut): self
    {
        $this->stockOut = $stockOut;

        return $this;
    }

    public function getShowSupplier(): ?string
    {
        return $this->showSupplier;
    }

    public function setShowSupplier(?string $showSupplier): self
    {
        $this->showSupplier = $showSupplier;

        return $this;
    }

    public function getSupplierAmount(): ?string
    {
        return $this->supplierAmount;
    }

    public function setSupplierAmount(?string $supplierAmount): self
    {
        $this->supplierAmount = $supplierAmount;

        return $this;
    }

    public function getShowClient(): ?string
    {
        return $this->showClient;
    }

    public function setShowClient(?string $showClient): self
    {
        $this->showClient = $showClient;

        return $this;
    }

    public function getClientAmount(): ?string
    {
        return $this->clientAmount;
    }

    public function setClientAmount(?string $clientAmount): self
    {
        $this->clientAmount = $clientAmount;

        return $this;
    }

    public function getUseCashier(): ?string
    {
        return $this->useCashier;
    }

    public function setUseCashier(?string $useCashier): self
    {
        $this->useCashier = $useCashier;

        return $this;
    }

    public function getInstitutionName(): ?string
    {
        return $this->institutionName;
    }

    public function setInstitutionName(?string $institutionName): self
    {
        $this->institutionName = $institutionName;

        return $this;
    }
}
