<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TTransactionsCashierRepository;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Validator\Constraints\DateTime;

/**
 * @ApiResource(
 *      normalizationContext={"groups"={"t_transactions_cashiers:read"}, "swagger_definition_name"="Read"},
 *     denormalizationContext={"groups"={"t_transactions_cashiers:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "account2": "exact", "coaCode": "exact", "transactionType": "exact", "transactionNoId": "exact" })
 * @ApiFilter(DateFilter::class, properties={"transactionDocDate"})
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TTransactionsCashierRepository::class)
 */

class TTransactionsCashier
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_transactions_cashiers:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $transactionSystemNo;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $transactionType;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $transactionDocNo;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $transactionDocDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $transactionSystemDate;

    /**
     * @ORM\Column(type="time", nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $transactionSystemTime;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $narration;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $drCr;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $totalDiscAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $totalAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $totalTax;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $grandTotal;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $balance;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $coaCode;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $lastModifiedOn;

    /**
     * @ORM\ManyToOne(targetEntity=TAccounts::class, inversedBy="tTransactionsCashiers")
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $account;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $detailsId;

    /**
     * @ORM\ManyToOne(targetEntity=TAccounts::class, inversedBy="tTransactionsCashiers")
     * @Groups({"t_transactions_cashiers:read", "t_transactions_cashiers:write"})
     */
    private $account2;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTransactionSystemNo(): ?string
    {
        return $this->transactionSystemNo;
    }

    public function setTransactionSystemNo(?string $transactionSystemNo): self
    {
        $this->transactionSystemNo = $transactionSystemNo;

        return $this;
    }

    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    public function setTransactionType(?string $transactionType): self
    {
        $this->transactionType = $transactionType;

        return $this;
    }

    public function getTransactionDocNo(): ?string
    {
        return $this->transactionDocNo;
    }

    public function setTransactionDocNo(?string $transactionDocNo): self
    {
        $this->transactionDocNo = $transactionDocNo;

        return $this;
    }

    public function getTransactionDocDate(): ?\DateTimeInterface
    {
        return $this->transactionDocDate;
    }

    public function setTransactionDocDate(?\DateTimeInterface $transactionDocDate): self
    {
        $this->transactionDocDate = $transactionDocDate;

        return $this;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getTransactionSystemTime(): ?\DateTimeInterface
    {
        return $this->transactionSystemTime;
    }

    public function setTransactionSystemTime(?\DateTimeInterface $transactionSystemTime): self
    {
        $this->transactionSystemTime = $transactionSystemTime;

        return $this;
    }

    public function getNarration(): ?string
    {
        return $this->narration;
    }

    public function setNarration(?string $narration): self
    {
        $this->narration = $narration;

        return $this;
    }

    public function getDrCr(): ?string
    {
        return $this->drCr;
    }

    public function setDrCr(?string $drCr): self
    {
        $this->drCr = $drCr;

        return $this;
    }

    public function getTotalDiscAmount(): ?string
    {
        return $this->totalDiscAmount;
    }

    public function setTotalDiscAmount(?string $totalDiscAmount): self
    {
        $this->totalDiscAmount = $totalDiscAmount;

        return $this;
    }

    public function getTotalAmount(): ?string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(?string $totalAmount): self
    {
        $this->totalAmount = $totalAmount;

        return $this;
    }

    public function getTotalTax(): ?string
    {
        return $this->totalTax;
    }

    public function setTotalTax(?string $totalTax): self
    {
        $this->totalTax = $totalTax;

        return $this;
    }

    public function getGrandTotal(): ?string
    {
        return $this->grandTotal;
    }

    public function setGrandTotal(?string $grandTotal): self
    {
        $this->grandTotal = $grandTotal;

        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $balance): self
    {
        $this->balance = $balance;

        return $this;
    }

    public function getCoaCode(): ?string
    {
        return $this->coaCode;
    }

    public function setCoaCode(?string $coaCode): self
    {
        $this->coaCode = $coaCode;

        return $this;
    }

    public function getLastModifiedOn(): ?\DateTimeInterface
    {
        return $this->lastModifiedOn;
    }

    public function setLastModifiedOn(?\DateTimeInterface $lastModifiedOn): self
    {
        $this->lastModifiedOn = $lastModifiedOn;

        return $this;
    }

    public function getAccount(): ?TAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getDetailsId(): ?int
    {
        return $this->detailsId;
    }

    public function setDetailsId(?int $detailsId): self
    {
        $this->detailsId = $detailsId;

        return $this;
    }

    public function getAccount2(): ?TAccounts
    {
        return $this->account2;
    }

    public function setAccount2(?TAccounts $account2): self
    {
        $this->account2 = $account2;

        return $this;
    }
}
