<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use App\Repository\TTransactionsDetailsRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Validator\Constraints\DateTime;

/**
 * @ApiResource(
 *     normalizationContext={"groups"={"t_transactions_details:read"}, "swagger_definition_name"="Read"},
 *     denormalizationContext={"groups"={"t_transactions_details:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={
 *                                            "transactionType": "exact",
 *                                        "transactionSystemNo": "exact",
 *                                              "transactionNo": "exact",
 *                                            "transactionNoId": "exact",
 *                                                       "item": "exact",
 *                                                     "status": "exact",
 *                                                         "id": "ASC" })
 * @ApiFilter(DateFilter::class, properties={ "transactionSystemDate", "transactionDocDate"})
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TTransactionsDetailsRepository::class)
 */
class TTransactionsDetails
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_inventory_list:read", "t_transactions_details:write", "t_transactions_details:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $transactionType;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $transactionSystemNo;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $transactionDocDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="transaction_system_date", type="datetime", nullable=false, options={"default"="CURRENT_TIMESTAMP"})
     * @Groups({"t_transactions_accounts:read", "t_transactions_details:write", "t_transactions_details:read", "t_inventory_list:read"})
    */
    private $transactionSystemDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="transaction_system_time", type="datetime", nullable=false, options={"default"="CURRENT_TIMESTAMP"})
     * @Groups({"t_transactions_accounts:read", "t_transactions_details:write"})
    */
    private $transactionSystemTime;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $coaNo;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read", "t_inventory_list:read"})
     */
    private $qty;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $cost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $price;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $discPercent;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $discAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $amount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $taxPercent;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $taxAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $totalCost;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $status;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $lastModifiedBy;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $lastModifiedOn;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $transactionDocNo;

    /**
     * @ORM\ManyToOne(targetEntity=TInventoryList::class, inversedBy="details")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write", "t_inventory_list:read"})
     */
    private $item;

    /**
     * @ORM\ManyToOne(targetEntity=TAccounts::class, inversedBy="details")
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $account;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $transactionNoId;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $costOfGoodsSold;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory_list:read", "t_transactions_details:read", "t_transactions_details:write"})
     */
    private $profitMargin;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $offerApplied;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $offerPercent;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details:write", "t_transactions_details:read"})
     */
    private $offerAmount;


    public function __construct()
    {
        $this->transactionSystemDate = new \DateTime();
        $this->transactionSystemTime = new \DateTime();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    public function setTransactionType(?string $transactionType): self
    {
        $this->transactionType = $transactionType;

        return $this;
    }

    public function getTransactionSystemNo(): ?string
    {
        return $this->transactionSystemNo;
    }

    public function setTransactionSystemNo(?string $transactionSystemNo): self
    {
        $this->transactionSystemNo = $transactionSystemNo;

        return $this;
    }

    public function getTransactionDocDate(): ?\DateTimeInterface
    {
        return $this->transactionDocDate;
    }

    public function setTransactionDocDate(?\DateTimeInterface $transactionDocDate): self
    {
        $this->transactionDocDate = $transactionDocDate;

        return $this;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getTransactionSystemTime(): ?\DateTimeInterface
    {
        return $this->transactionSystemTime;
    }

    public function setTransactionSystemTime(?\DateTimeInterface $transactionSystemTime): self
    {
        $this->transactionSystemTime = $transactionSystemTime;

        return $this;
    }

    public function getCoaNo(): ?int
    {
        return $this->coaNo;
    }

    public function setCoaNo(?int $coaNo): self
    {
        $this->coaNo = $coaNo;

        return $this;
    }

    public function getQty(): ?int
    {
        return $this->qty;
    }

    public function setQty(?int $qty): self
    {
        $this->qty = $qty;

        return $this;
    }

    public function getCost(): ?string
    {
        return $this->cost;
    }

    public function setCost(?string $cost): self
    {
        $this->cost = $cost;

        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getDiscPercent(): ?string
    {
        return $this->discPercent;
    }

    public function setDiscPercent(?string $discPercent): self
    {
        $this->discPercent = $discPercent;

        return $this;
    }

    public function getDiscAmount(): ?string
    {
        return $this->discAmount;
    }

    public function setDiscAmount(?string $discAmount): self
    {
        $this->discAmount = $discAmount;

        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getTaxPercent(): ?string
    {
        return $this->taxPercent;
    }

    public function setTaxPercent(?string $taxPercent): self
    {
        $this->taxPercent = $taxPercent;

        return $this;
    }

    public function getTaxAmount(): ?string
    {
        return $this->taxAmount;
    }

    public function setTaxAmount(?string $taxAmount): self
    {
        $this->taxAmount = $taxAmount;

        return $this;
    }

    public function getTotalCost(): ?string
    {
        return $this->totalCost;
    }

    public function setTotalCost(?string $totalCost): self
    {
        $this->totalCost = $totalCost;
        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getLastModifiedBy(): ?int
    {
        return $this->lastModifiedBy;
    }

    public function setLastModifiedBy(?int $lastModifiedBy): self
    {
        $this->lastModifiedBy = $lastModifiedBy;

        return $this;
    }

    public function getLastModifiedOn(): ?\DateTimeInterface
    {
        return $this->lastModifiedOn;
    }

    public function setLastModifiedOn(?\DateTimeInterface $lastModifiedOn): self
    {
        $this->lastModifiedOn = $lastModifiedOn;

        return $this;
    }

    public function getTransactionDocNo(): ?string
    {
        return $this->transactionDocNo;
    }

    public function setTransactionDocNo(?string $transactionDocNo): self
    {
        $this->transactionDocNo = $transactionDocNo;

        return $this;
    }

    public function getItem(): ?TInventoryList
    {
        return $this->item;
    }

    public function setItem(?TInventoryList $item): self
    {
        $this->item = $item;

        return $this;
    }

    public function getAccount(): ?TAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getTransactionNoId(): ?int
    {
        return $this->transactionNoId;
    }

    public function setTransactionNoId(?int $transactionNoId): self
    {
        $this->transactionNoId = $transactionNoId;

        return $this;
    }

    public function getCostOfGoodsSold(): ?string
    {
        return $this->costOfGoodsSold;
    }

    public function setCostOfGoodsSold(?string $costOfGoodsSold): self
    {
        $this->costOfGoodsSold = $costOfGoodsSold;

        return $this;
    }

    public function getProfitMargin(): ?string
    {
        return $this->profitMargin;
    }

    public function setProfitMargin(?string $profitMargin): self
    {
        $this->profitMargin = $profitMargin;

        return $this;
    }

    public function getOfferApplied(): ?string
    {
        return $this->offerApplied;
    }

    public function setOfferApplied(?string $offerApplied): self
    {
        $this->offerApplied = $offerApplied;

        return $this;
    }

    public function getOfferPercent(): ?string
    {
        return $this->offerPercent;
    }

    public function setOfferPercent(?string $offerPercent): self
    {
        $this->offerPercent = $offerPercent;

        return $this;
    }

    public function getOfferAmount(): ?string
    {
        return $this->offerAmount;
    }

    public function setOfferAmount(?string $offerAmount): self
    {
        $this->offerAmount = $offerAmount;

        return $this;
    }

}
